/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vpn;

import ibm.nways.ipv6.IPv4v6Address;
import ibm.nways.jdm.common.OID;
import java.io.Serializable;

class VpnDevice
implements Serializable {
    String name;
    IPv4v6Address ipAddress;
    int devType;
    int ovid;
    String communityRead;
    String communityWrite;
    Integer retry;
    Integer timeout;
    String description;
    boolean user;
    static final int COLUMNS = 7;
    static final int NAME = 0;
    static final int IPADDR = 1;
    static final int DEVTYPE = 2;
    static final int COMMUNITYREAD = 3;
    static final int COMMUNITYWRITE = 4;
    static final int RETRY = 5;
    static final int TIMEOUT = 6;
    static final int DESCRIPTION = 7;
    public static final int UNKNOWN = 0;
    public static final int[] deviceIndex;
    public static final String[] JMAclass;
    public static final String[] deviceShortName;
    public static final String[] deviceLongNLSname;
    public static final OID[] oidValues;

    public static int short2int(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < deviceShortName.length) {
            if (deviceShortName[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                return deviceIndex[0];
            }
            case 1: {
                return deviceIndex[1];
            }
            case 2: {
                return deviceIndex[2];
            }
            case 3: {
                return deviceIndex[3];
            }
            case 4: {
                return deviceIndex[4];
            }
        }
        return deviceIndex[0];
    }

    public static int oidToNumeric(String string) {
        OID oID = new OID(string);
        int n = 0;
        int n2 = 0;
        while (n2 < oidValues.length) {
            if (oidValues[n2].equals(oID)) {
                n = n2;
                break;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                return deviceIndex[0];
            }
            case 1: {
                return deviceIndex[1];
            }
            case 2: {
                return deviceIndex[2];
            }
            case 3: {
                return deviceIndex[3];
            }
            case 4: {
                return deviceIndex[4];
            }
        }
        return deviceIndex[0];
    }

    public VpnDevice(String string, String string2, String string3, String string4, int n, Integer n2, Integer n3, String string5) {
        this(string, string2, string3, string4, n, n2, n3, string5, false);
    }

    public VpnDevice(String string, String string2, String string3, String string4, int n, Integer n2, Integer n3, String string5, boolean bl) {
        this.name = string;
        this.ipAddress = new IPv4v6Address(string2);
        this.communityRead = string3;
        this.communityWrite = string4;
        this.devType = n;
        this.retry = n2;
        this.timeout = n3;
        this.description = string5;
        this.user = bl;
    }

    public void setIpAddr(String string) {
        this.ipAddress = new IPv4v6Address(string);
    }

    public void setOVID(int n) {
        this.ovid = n;
    }

    public int getOVID() {
        return this.ovid;
    }

    public void change(VpnDevice vpnDevice) {
        this.name = vpnDevice.name;
        this.ipAddress = vpnDevice.ipAddress;
        this.communityRead = vpnDevice.communityRead;
        this.communityWrite = vpnDevice.communityWrite;
        this.devType = vpnDevice.devType;
        this.retry = vpnDevice.retry;
        this.timeout = vpnDevice.timeout;
        this.description = vpnDevice.description;
        this.user = vpnDevice.user;
    }

    public String toString() {
        return "name = " + this.name + ", ipAddr = " + this.ipAddress.toString() + ", communityRead = " + this.communityRead + ", communityWrite = " + this.communityWrite + ", devType = " + deviceShortName[this.devType] + ", retry = " + this.retry + ", timeout = " + this.timeout + ", description = " + this.description;
    }

    public String asString() {
        return String.valueOf(this.name) + "," + this.ipAddress.toString() + "," + this.atLeastSpace(this.communityRead) + "," + this.atLeastSpace(this.communityWrite) + "," + deviceShortName[this.devType] + "," + this.retry + "," + this.timeout + "," + this.atLeastSpace(this.description) + ",*";
    }

    private String atLeastSpace(String string) {
        if (string == null || string.equals("")) {
            return " ";
        }
        return string;
    }

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        deviceIndex = nArray;
        JMAclass = new String[]{"unknown", "ibm.nways.jdm2210.Jdm2210", "ibm.nways.jdm2212.Jdm2212", "ibm.nways.jdm2216.Jdm2216", "ibm.nways.jdmnetu.JdmNetU"};
        deviceShortName = new String[]{"unknown", "IBM2210", "IBM2212", "IBM2216", "IBMNetU"};
        deviceLongNLSname = new String[]{"unknown", "2210NLS", "2212NLS", "2216NLS", "NetUNLS"};
        oidValues = new OID[]{new OID("0.0.0"), new OID("1.3.6.1.4.1.2.6.72"), new OID("1.3.6.1.4.1.2.3.37"), new OID("1.3.6.1.4.1.2.6.131"), new OID("1.3.6.1.4.1.2.3.39")};
    }
}

